/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.craftingmanager.system;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import mcjty.rftoolsstorage.modules.craftingmanager.devices.VanillaCraftingDevice;
import mcjty.rftoolsstorage.modules.craftingmanager.system.ICraftingDevice;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;

public class CraftingDeviceRegistry {
    private final Map<ResourceLocation, ResourceLocation> blockToDeviceMap = new HashMap<ResourceLocation, ResourceLocation>();
    private final Map<ResourceLocation, Supplier<ICraftingDevice>> deviceToSupplierMap = new HashMap<ResourceLocation, Supplier<ICraftingDevice>>();

    public void init() {
        this.register(Blocks.f_50091_.getRegistryName(), VanillaCraftingDevice.DEVICE_VANILLA_CRAFTING, VanillaCraftingDevice::new);
    }

    public void register(ResourceLocation blockId, ResourceLocation deviceId, Supplier<ICraftingDevice> device) {
        this.blockToDeviceMap.put(blockId, deviceId);
        this.deviceToSupplierMap.put(deviceId, device);
    }

    public ResourceLocation getDeviceForBlock(ResourceLocation blockId) {
        return this.blockToDeviceMap.get(blockId);
    }

    public Supplier<ICraftingDevice> getDeviceSupplier(ResourceLocation deviceId) {
        return this.deviceToSupplierMap.get(deviceId);
    }
}

